unit Main;
                { Copyright  1998 by Igor Glukhov}
                     { Project name: ProHelp}
//{$Define Delphi20}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, ProHelp, Buttons, Menus, Registry, ShellApi;

const
  ACT_COUNTER_INIT_VALUE = {$IFDEF Delphi20} 0 {$ELSE} 1 {$ENDIF};
  WH_CLOSE_ALL = 'CW("main");CW("DemoWnd");CW("RWnd")';
  HAND_POINT_CURSOR = 5;

var
  Skip: Boolean;
  MFActCounter: Integer;
  DBActCounter: Integer;
  Reg:  TRegistry;

type
  TMainForm = class(TForm)
    cbNonStopHelp: TCheckBox;
    cbPopUpWhatIsThis: TCheckBox;
    cbMenuRButtonHelp: TCheckBox;
    cbPopUpIsDefaultWnd: TCheckBox;
    cbCheckHCSign: TCheckBox;
    cbBeepIfNoHelp: TCheckBox;
    cbUseSystemStdTopics: TCheckBox;
    cbAutoHelpButton: TCheckBox;
    cbNCObjHints: TCheckBox;
    cbSmallCursor: TCheckBox;
    cbUseHelpFinderCmd: TCheckBox;
    cbMainFrmRButtonHelp: TCheckBox;
    cbDlgForceSmallCursor: TCheckBox;
    cbDlgAllowNonStop: TCheckBox;
    cbDlgAllowHelpMode: TCheckBox;
    cbDlgCheckHelpButton: TCheckBox;
    cbMainForm: TCheckBox;
    cbPopupStdTopics: TCheckBox;
    GroupBox2: TGroupBox;
    GroupBox1: TGroupBox;
    GroupBox3: TGroupBox;
    ToolBar: TPanel;
    NewSB: TSpeedButton;
    OpenSB: TSpeedButton;
    SaveSB: TSpeedButton;
    ControlMenu: TPopupMenu;
    miNonStopHelp: TMenuItem;
    miBeepIfNoHelp: TMenuItem;
    miMenuRButtonHelp: TMenuItem;
    PrintSB: TSpeedButton;
    PrintPreviewSB: TSpeedButton;
    tbDev1: TBevel;
    tbDev2: TBevel;
    miNCObjHints: TMenuItem;
    miPopUpWhatIsThis: TMenuItem;
    miMainFrmRButtonHelp: TMenuItem;
    miUseSystemStdTopics: TMenuItem;
    miUseHelpFinderCmd: TMenuItem;
    miPopUpIsDefaultWnd: TMenuItem;
    miSmallCursor: TMenuItem;
    gbNonwindowedControls: TGroupBox;
    TShapeControl: TShape;
    TImageControl: TImage;
    TLabelControl: TLabel;
    gbEditControl: TGroupBox;
    EditControlLabel: TLabel;
    MemoControl: TMemo;
    EditControl: TEdit;
    gbStdButtons: TGroupBox;
    ApplyButton: TButton;
    CancelButton: TButton;
    OKButton: TButton;
    HelpButton: TButton;
    miDlgAllowNonStop: TMenuItem;
    miDlgAllowHelpMode: TMenuItem;
    miDlgCheckHelpButton: TMenuItem;
    miDlgForceSmallCursor: TMenuItem;
    CloseSB: TSpeedButton;
    UndoSB: TSpeedButton;
    CutSB: TSpeedButton;
    CopySB: TSpeedButton;
    PasteSB: TSpeedButton;
    tbDev3: TBevel;
    miAutoHelpButton: TMenuItem;
    OpenDialog: TOpenDialog;
    gbControlFlags: TGroupBox;
    MainMenu: TMainMenu;
    File1: TMenuItem;
    miNew: TMenuItem;
    miOpen: TMenuItem;
    miClose: TMenuItem;
    miDev1: TMenuItem;
    miSave: TMenuItem;
    miDev2: TMenuItem;
    miPrintPreview: TMenuItem;
    miPrint: TMenuItem;
    miDev5: TMenuItem;
    miExit: TMenuItem;
    Edit3: TMenuItem;
    miUndo: TMenuItem;
    miDev4: TMenuItem;
    miCut: TMenuItem;
    miCopy: TMenuItem;
    miPaste: TMenuItem;
    miHelp: TMenuItem;
    miHelpContents: TMenuItem;
    miWhatIsThis: TMenuItem;
    miDev3: TMenuItem;
    miAbout: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    miCheckHCSign: TMenuItem;
    miOperatingMode: TMenuItem;
    N3: TMenuItem;
    GroupBox4: TGroupBox;
    FastLearnButton: TButton;
    ResetButton: TButton;
    gbComments: TGroupBox;
    miPopupStdTopics: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label13: TLabel;
    Label14: TLabel;
    Label23: TLabel;
    Label15: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    igHelpButton1: TigHelpButton;
    DelphiDlgButton: TButton;
    igStatusBar: TStatusBar;
    igHelpMonitor1: TigHelpMonitor;
    Registering1: TMenuItem;
    procedure CheckBoxStateChanged(Sender: TObject);
    procedure UpdateCheckBoxes(Sender: TObject);
    procedure MenuItemStateChanged(Sender: TObject);
    procedure ResetDefaults(Sender: TObject);
    procedure DelphiDlgButtonClick(Sender: TObject);
    procedure cbMainFormClick(Sender: TObject);
    procedure ResetButtonClick(Sender: TObject);
    procedure FastLearnButtonClick(Sender: TObject);
    procedure miHelpContentsClick(Sender: TObject);
    procedure AppActivate(Sender: TObject);
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure ExecuteWinHelpMacro(MacroStr: string);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure miOperatingModeClick(Sender: TObject);
    procedure ResetControlItems(Lock: Boolean);
    procedure SetFastLearningMode;
    procedure SetHandPointCursor(WinControl: TWinControl);
    procedure miAboutClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Label4Click(Sender: TObject);
    procedure Label6Click(Sender: TObject);
    procedure Label9Click(Sender: TObject);
    procedure Label21Click(Sender: TObject);
    procedure Label22Click(Sender: TObject);
    procedure Label23Click(Sender: TObject);
    procedure Label17Click(Sender: TObject);
    procedure Label20Click(Sender: TObject);
    procedure igHelpMonitor1ExitHelpMode(Sender: TObject);
    procedure igHelpMonitor1EnterHelpMode(Sender: TObject);
    procedure Registering1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure MainFormChanged(Form: TForm);
  end;

var
 MainForm: TMainForm;

implementation
{$R *.DFM}

uses Modal, About;

procedure TMainForm.ExecuteWinHelpMacro(MacroStr: string);
begin
  WinHelp(Application.Handle,'ProHelp.hlp',HELP_COMMAND,Integer(MacroStr));
end;


procedure TMainForm.CheckBoxStateChanged(Sender: TObject);
var
 Form: TForm;
begin
  if Skip then exit;         
  Form := TForm(TCheckBox(Sender).Owner);
  with igHelpMonitor1 do begin
    ControlFlags := [];
    if TMainForm(Form).cbBeepIfNoHelp.checked        then  ControlFlags := ControlFlags + [cfBeepIfNoHelp];
    if TMainForm(Form).cbUseSystemStdTopics.checked  then  ControlFlags := ControlFlags + [cfUseSystemStdTopics];
    if TMainForm(Form).cbMainFrmRButtonHelp.checked  then  ControlFlags := ControlFlags + [cfMainFrmRButtonHelp];
    if TMainForm(Form).cbMenuRButtonHelp.checked     then  ControlFlags := ControlFlags + [cfMenuRButtonHelp];
    if TMainForm(Form).cbNCObjHints.checked          then  ControlFlags := ControlFlags + [cfNCObjHints];
    if TMainForm(Form).cbNonStopHelp.checked         then  ControlFlags := ControlFlags + [cfNonStopHelp];
    if TMainForm(Form).cbPopUpIsDefaultWnd.checked   then  begin
      ControlFlags := ControlFlags + [cfPopUpIsDefaultWnd];
      ExecuteWinHelpMacro(WH_CLOSE_ALL); //CloseHelpWindows;
    end;
    if TMainForm(Form).cbCheckHCSign.checked         then  ControlFlags := ControlFlags + [cfCheckHCSign];
    if TMainForm(Form).cbPopUpWhatIsThis.checked     then  ControlFlags := ControlFlags + [cfPopUpWhatIsThis];
    if TMainForm(Form).cbSmallCursor.checked         then  ControlFlags := ControlFlags + [cfSmallCursor];
    if TMainForm(Form).cbUseHelpFinderCmd.checked    then  ControlFlags := ControlFlags + [cfUseHelpFinderCmd];
    if TMainForm(Form).cbDlgAllowNonStop.checked     then  ControlFlags := ControlFlags + [cfDlgAllowNonStop];
    if TMainForm(Form).cbDlgCheckHelpButton.checked  then  ControlFlags := ControlFlags + [cfDlgCheckHelpButton];
    if TMainForm(Form).cbDlgAllowHelpMode.checked    then  ControlFlags := ControlFlags + [cfDlgAllowHelpMode];
    if TMainForm(Form).cbDlgForceSmallCursor.checked then  ControlFlags := ControlFlags + [cfDlgForceSmallCursor];
    if TMainForm(Form).cbAutoHelpButton.checked      then  ControlFlags := ControlFlags + [cfAutoHelpButton];
    if TMainForm(Form).cbPopupStdTopics.checked      then  ControlFlags := ControlFlags + [cfPopUpStdTopics];
  end;
  UpdateCheckBoxes(Form);
end;

procedure TMainForm.UpdateCheckBoxes(Sender: TObject);
begin
  Skip := True;
  with igHelpMonitor1 do
    with ControlMenu do begin
      // Control panel
      TMainForm(Sender).cbBeepIfNoHelp.checked          := cfBeepIfNoHelp in ControlFlags;
      TMainForm(Sender).cbUseSystemStdTopics.checked    := cfUseSystemStdTopics in ControlFlags;
      TMainForm(Sender).cbMainFrmRButtonHelp.checked    := cfMainFrmRButtonHelp  in ControlFlags;
      TMainForm(Sender).cbMenuRButtonHelp.checked       := cfMenuRButtonHelp in ControlFlags;
      TMainForm(Sender).cbNCObjHints.checked            := cfNCObjHints in ControlFlags;
      TMainForm(Sender).cbNonStopHelp.checked           := cfNonStopHelp in ControlFlags;
      TMainForm(Sender).cbPopUpIsDefaultWnd.checked     := cfPopUpIsDefaultWnd in ControlFlags;
      TMainForm(Sender).cbCheckHCSign.checked           := cfCheckHCSign in ControlFlags;
      TMainForm(Sender).cbPopUpWhatIsThis.checked       := cfPopUpWhatIsThis in ControlFlags;
      TMainForm(Sender).cbSmallCursor.checked           := cfSmallCursor in ControlFlags;
      TMainForm(Sender).cbUseHelpFinderCmd.checked      := cfUseHelpFinderCmd in ControlFlags;
      TMainForm(Sender).cbDlgAllowNonStop.checked       := cfDlgAllowNonStop in ControlFlags;
      TMainForm(Sender).cbDlgCheckHelpButton.checked    := cfDlgCheckHelpButton in ControlFlags;
      TMainForm(Sender).cbDlgAllowHelpMode.checked      := cfDlgAllowHelpMode in ControlFlags;
      TMainForm(Sender).cbDlgForceSmallCursor.checked   := cfDlgForceSmallCursor in ControlFlags;
      TMainForm(Sender).cbAutoHelpButton.checked        := cfAutoHelpButton in ControlFlags;
      TMainForm(Sender).cbPopupStdTopics.checked        := cfPopupStdTopics in ControlFlags;
      // Control menu
      miBeepIfNoHelp.checked          := cfBeepIfNoHelp in ControlFlags;
      miUseSystemStdTopics.checked    := cfUseSystemStdTopics in ControlFlags;
      miMainFrmRButtonHelp.checked    := cfMainFrmRButtonHelp  in ControlFlags;
      miMenuRButtonHelp.checked       := cfMenuRButtonHelp in ControlFlags;
      miNCObjHints.checked            := cfNCObjHints in ControlFlags;
      miNonStopHelp.checked           := cfNonStopHelp in ControlFlags;
      miPopUpIsDefaultWnd.checked     := cfPopUpIsDefaultWnd in ControlFlags;
      miCheckHCSign.checked           := cfCheckHCSign in ControlFlags;
      miPopUpWhatIsThis.checked       := cfPopUpWhatIsThis in ControlFlags;
      miSmallCursor.checked           := cfSmallCursor in ControlFlags;
      miUseHelpFinderCmd.checked      := cfUseHelpFinderCmd in ControlFlags;
      miDlgAllowNonStop.checked       := cfDlgAllowNonStop in ControlFlags;
      miDlgCheckHelpButton.checked    := cfDlgCheckHelpButton in ControlFlags;
      miDlgAllowHelpMode.checked      := cfDlgAllowHelpMode in ControlFlags;
      miDlgForceSmallCursor.checked   := cfDlgForceSmallCursor in ControlFlags;
      miAutoHelpButton.checked        := cfAutoHelpButton in ControlFlags;
      miPopupStdTopics.checked        := cfPopupStdTopics in ControlFlags;
  end;
  Skip := False;
end;

procedure TMainForm.MenuItemStateChanged(Sender: TObject);
begin
  TMenuItem(Sender).Checked := not TMenuItem(Sender).Checked;
  if Skip then exit;
  with igHelpMonitor1 do begin
    with ControlMenu do begin
      ControlFlags := [];
      if miBeepIfNoHelp.checked        then  ControlFlags := ControlFlags + [cfBeepIfNoHelp];
      if miUseSystemStdTopics.checked    then  ControlFlags := ControlFlags + [cfUseSystemStdTopics];
      if miMainFrmRButtonHelp.checked  then  ControlFlags := ControlFlags + [cfMainFrmRButtonHelp];
      if miMenuRButtonHelp.checked     then  ControlFlags := ControlFlags + [cfMenuRButtonHelp];
      if miNCObjHints.checked          then  ControlFlags := ControlFlags + [cfNCObjHints];
      if miNonStopHelp.checked         then  ControlFlags := ControlFlags + [cfNonStopHelp];
      if miPopUpIsDefaultWnd.checked   then  ControlFlags := ControlFlags + [cfPopUpIsDefaultWnd];
      if miCheckHCSign.checked         then  ControlFlags := ControlFlags + [cfCheckHCSign];
      if miPopUpWhatIsThis.checked     then  ControlFlags := ControlFlags + [cfPopUpWhatIsThis];
      if miSmallCursor.checked         then  ControlFlags := ControlFlags + [cfSmallCursor];
      if miUseHelpFinderCmd.checked    then  ControlFlags := ControlFlags + [cfUseHelpFinderCmd];
      if miDlgAllowNonStop.checked     then  ControlFlags := ControlFlags + [cfDlgAllowNonStop];
      if miDlgCheckHelpButton.checked  then  ControlFlags := ControlFlags + [cfDlgCheckHelpButton];
      if miDlgAllowHelpMode.checked    then  ControlFlags := ControlFlags + [cfDlgAllowHelpMode];
      if miDlgForceSmallCursor.checked then  ControlFlags := ControlFlags + [cfDlgForceSmallCursor];
      if miAutoHelpButton.checked      then  ControlFlags := ControlFlags + [cfAutoHelpButton];
      if miPopupStdTopics.checked      then  ControlFlags := ControlFlags + [cfPopupStdTopics];
    end;
  end;
  UpdateCheckBoxes(Screen.ActiveForm);
end;

procedure TMainForm.MainFormChanged(Form: TForm);
begin
  miDlgAllowNonStop.Enabled     := (Form <> MainForm) and (Form <> igHelpMonitor1.MainForm);
  miDlgCheckHelpButton.Enabled  := (Form <> MainForm) and (Form <> igHelpMonitor1.MainForm);
  miDlgAllowHelpMode.Enabled    := (Form <> MainForm) and (Form <> igHelpMonitor1.MainForm);
  miDlgForceSmallCursor.Enabled := (Form <> MainForm) and (Form <> igHelpMonitor1.MainForm);
  miMainFrmRButtonHelp.Enabled  := Form =  igHelpMonitor1.MainForm;
  miUseHelpFinderCmd.Enabled    := miMainFrmRButtonHelp.Enabled;
  TMainForm(Form).cbDlgAllowNonStop.Enabled     := (Form <> MainForm) and (Form <> igHelpMonitor1.MainForm);
  TMainForm(Form).cbDlgCheckHelpButton.Enabled  := (Form <> MainForm) and (Form <> igHelpMonitor1.MainForm);
  TMainForm(Form).cbDlgAllowHelpMode.Enabled    := (Form <> MainForm) and (Form <> igHelpMonitor1.MainForm);
  TMainForm(Form).cbDlgForceSmallCursor.Enabled := (Form <> MainForm) and (Form <> igHelpMonitor1.MainForm);
  TMainForm(Form).cbMainFrmRButtonHelp.Enabled  := miMainFrmRButtonHelp.Enabled;
  TMainForm(Form).cbUseHelpFinderCmd.Enabled    := miMainFrmRButtonHelp.Enabled;
end;

procedure TMainForm.ResetDefaults(Sender: TObject);
begin
  igHelpMonitor1.SetDefaultMode;
  igHelpMonitor1.MainForm := nil;
  TMainForm(Sender).cbMainForm.Checked := TForm(Sender) = MainForm;
  MainFormChanged(TForm(Sender));
  UpdateCheckBoxes(Sender);
end;

procedure TMainForm.DelphiDlgButtonClick(Sender: TObject);
begin
  Application.OnIdle := AppIdle;
  ModalForm.ShowModal;
end;

procedure TMainForm.cbMainFormClick(Sender: TObject);
var
 MForm: TForm;
begin
 MForm := MainForm;
 if not TCheckBox(Sender).Checked then MForm := ModalForm;
 MainForm.igHelpMonitor1.MainForm := MForm;
 MainFormChanged(MainForm);
end;

procedure TMainForm.ResetButtonClick(Sender: TObject);
begin
  miOperatingMode.Checked := False;
  ResetControlItems(True);
  ResetDefaults(Screen.ActiveForm);
  ExecuteWinHelpMacro(WH_CLOSE_ALL); //CloseHelpWindows;
end;

procedure TMainForm.SetFastLearningMode;
var
  Form: TForm;
begin
  igHelpMonitor1.SetNoviceUserMode;
  Form := Screen.ActiveForm;
  igHelpMonitor1.MainForm := nil;
  TMainForm(Form).cbMainForm.Checked := Form = MainForm;
  MainFormChanged(Form);
  UpdateCheckBoxes(Form);
end;

procedure TMainForm.FastLearnButtonClick(Sender: TObject);
begin
   ResetControlItems(True);
   SetFastLearningMode;
   miOperatingMode.Checked := False;
end;

procedure TMainForm.miHelpContentsClick(Sender: TObject);
begin
  if cbMainForm.Checked then igHelpMonitor1.ShowHelpContents;
end;

procedure TMainForm.AppIdle(Sender: TObject; var Done: Boolean);
begin
  Application.onIdle := nil;
  if Screen.ActiveForm = MainForm then
    ExecuteWinHelpMacro('JI("ProHelp.hlp>RWnd","M_210")')
  else if (Screen.ActiveForm = ModalForm) and (DBActCounter = 0) then
    ExecuteWinHelpMacro('JI("ProHelp.hlp>RWnd","M_220")');
end;


procedure TMainForm.AppActivate(Sender: TObject);
begin
  if Screen.ActiveForm = MainForm then begin
   inc(MFActCounter);
   if (MFActCounter = 1+ACT_COUNTER_INIT_VALUE) then ExecuteWinHelpMacro(WH_CLOSE_ALL);
  end
  else if Screen.ActiveForm = ModalForm then begin
   inc(DBActCounter);
   if (DBActCounter = 1) then ExecuteWinHelpMacro(WH_CLOSE_ALL);
  end;
end;

procedure TMainForm.SetHandPointCursor(WinControl: TWinControl);
var
 Ind: integer;
 Ctrl: TControl;
begin
  for Ind := 0 to WinControl.ControlCount -1 do begin
   Ctrl := WinControl.Controls[Ind];
   if (Ctrl is TLabel) and Assigned(TLabel(Ctrl).OnClick) then Ctrl.Cursor := HAND_POINT_CURSOR;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  ApplicationPath: string;
begin
  Screen.Cursors[HAND_POINT_CURSOR] := LoadCursor(HInstance,'WEBLINKCURSOR');
  SetHandPointCursor(gbComments);
  Application.OnActivate := AppActivate;
  Application.OnIdle := AppIdle;
  if Application.HelpFile = '' then begin
    //Check to see where ProHelp.Hlp resides.
    ApplicationPath := ExtractFilePath(Application.ExeName);
    Application.HelpFile := ApplicationPath + '..\Help\ProHelp.hlp';
    if not FileExists(Application.HelpFile) then begin
      Application.HelpFile := ApplicationPath + 'ProHelp.hlp';
      if not FileExists(Application.HelpFile) then begin
        Application.HelpFile := ApplicationPath + 'Help\ProHelp.hlp';
        if not FileExists(Application.HelpFile) then begin
          Application.HelpFile := ApplicationPath + '..\ProHelp.hlp';
          if not FileExists(Application.HelpFile) then begin
            Application.HelpFile := ApplicationPath + '..\..\Help\ProHelp.hlp';
            if not FileExists(Application.HelpFile) then begin
              Application.HelpFile := ApplicationPath + '..\..\ProHelp.hlp';
              if not FileExists(Application.HelpFile) then
                Application.HelpFile := 'ProHelp.hlp';
            end;
          end;
        end;
      end;
    end;
  end;
  igHelpMonitor1.StdHelpTopics.HelpFile := 'App';
  igHelpMonitor1.HelpWindowName := 'DemoWnd';
  if not (Application.HelpFile = 'ProHelp.hlp') then begin
    Reg := TRegistry.Create;
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Reg.OpenKey('Software\Microsoft\Windows\Help',True);
    Reg.WriteString('ProHelp.hlp',ExtractFilePath(Application.HelpFile));
  end;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  if not (igHelpMonitor1.StdHelpTopics.HelpFile <> 'ProHelp.hlp') then begin
    Reg.DeleteValue('ProHelp.hlp');
    Reg.Free;
  end;
  ExecuteWinHelpMacro(WH_CLOSE_ALL); //CloseHelpWindows;
end;

procedure TMainForm.ResetControlItems(Lock: Boolean);
var
  Ind: integer;
begin
  for Ind := 0 to ComponentCount - 1 do
    if Components[Ind] is TCheckBox and (Components[Ind].Name <> 'cbMainForm') then TCheckBox(Components[Ind]).Enabled := Lock;
  with ControlMenu do
    for Ind := 0 to  Items.Count-1 do Items[Ind].Enabled := Lock;
end;

procedure TMainForm.miOperatingModeClick(Sender: TObject);
begin
  With miOperatingMode do begin
    Checked := not Checked;
    if Checked then begin
      SetFastLearningMode;
      ResetControlItems(False);
    end
    else begin
      ResetControlItems(True);
      SetFastLearningMode;
    end;
  end;
end;

procedure TMainForm.miAboutClick(Sender: TObject);
begin
   ExecuteWinHelpMacro(WH_CLOSE_ALL); //CloseHelpWindows;
   ResetButtonClick(nil);
   AboutForm.ShowModal;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
 ResetDefaults(Sender);
end;

procedure TMainForm.Label4Click(Sender: TObject);
begin
 MFActCounter := ACT_COUNTER_INIT_VALUE;
 ExecuteWinHelpMacro('JI("ProHelp.hlp>RWnd","M_210")');
end;

procedure TMainForm.Label6Click(Sender: TObject);
begin
 MFActCounter := ACT_COUNTER_INIT_VALUE;
 ExecuteWinHelpMacro('JI("ProHelp.hlp>RWnd","M_220")');
end;

procedure TMainForm.Label9Click(Sender: TObject);
begin
 MFActCounter := ACT_COUNTER_INIT_VALUE;
 WinHelp(Self.Handle,'ProHelp.hlp',HELP_FINDER,0);
end;

procedure TMainForm.Label21Click(Sender: TObject);
begin
   ShellExecute(Self.Handle,'open','http://igweb.pair.com',nil,nil,SW_SHOWNORMAL);
end;

procedure TMainForm.Label22Click(Sender: TObject);
begin
  ShellExecute(Self.Handle,'open','mailto:prohelp@igweb.pair.com',nil,nil,SW_SHOWNORMAL);
end;

procedure TMainForm.Label23Click(Sender: TObject);
begin
  ShellExecute(Self.Handle,'open','mailto:prohelp_mailinglist@igweb.pair.com',nil,nil,SW_SHOWNORMAL);
end;

procedure TMainForm.Label17Click(Sender: TObject);
begin
 MFActCounter := ACT_COUNTER_INIT_VALUE;
 ExecuteWinHelpMacro('JI("ProHelp.hlp>RWnd","IDH_APP_HMB")');
end;

procedure TMainForm.Label20Click(Sender: TObject);
begin
 MFActCounter := ACT_COUNTER_INIT_VALUE;
 ExecuteWinHelpMacro('JI("ProHelp.hlp>RWnd","M_10")');
end;

procedure TMainForm.igHelpMonitor1ExitHelpMode(Sender: TObject);
begin
  with igHelpMonitor1 do
    if (cfNonStopHelp in ControlFlags) and not ((Screen.ActiveForm = ModalForm) and (igHelpMonitor1.MainForm <> ModalForm)
      and not (cfDlgAllowNonStop in igHelpMonitor1.ControlFlags))
    then
      ExecuteWinHelpMacro(WH_CLOSE_ALL);
end;

procedure TMainForm.igHelpMonitor1EnterHelpMode(Sender: TObject);
begin
  ExecuteWinHelpMacro(WH_CLOSE_ALL);
end;

procedure TMainForm.Registering1Click(Sender: TObject);
begin
  ExecuteWinHelpMacro('JI("ProHelp.hlp>RWnd","M_4270")');
end;

end.
